(function ($) {
	'use strict';

	jQuery(function ($) {

		var message = {
			fadeInTime: 600,
			fadeOuttime: 600,
			howLongToShow: pisol_mmq.howLongToShow,
			showContinues: pisol_mmq.showContinues,
			show: function () {
				message.hide_progress();
				jQuery('.pisol-mmq-bar-container').fadeIn(message.fadeInTime);
				if (!message.showContinues) {
					setTimeout(function () { message.hide(); }, message.howLongToShow);
				}
			},

			hide: function () {
				message.show_progress();
				jQuery('.pisol-mmq-bar-container').fadeOut(message.fadeOuttime);
			},

			close_button: function () {
				jQuery('.pisol-mmq-close').click(function () {
					message.hide();
				});
			},

			hide_progress: function () {
				jQuery('#pi-mmq-progress-circle').fadeOut();
			},

			show_progress: function () {
				jQuery('#pi-mmq-progress-circle').fadeIn();
			},

			close_progress: function () {
				jQuery('#pi-mmq-progress-circle').on('click', function () {
					message.hide_progress();
					message.show();
				});
			},


			update_cart: function () {
				// update total amount after click add_to_cart
				jQuery(document).ajaxComplete(function (event, jqxhr, settings) {
					var ajax_link = settings.url;

					if (ajax_link && ajax_link != 'undefined' && ajax_link.search(/wc-ajax=add_to_cart/i) >= 0 || ajax_link.search(/wc-ajax=remove_from_cart/i) >= 0 || ajax_link.search(/wc-ajax=get_refreshed_fragments/i) >= 0 || ajax_link.search(/admin-ajax\.php/i) >= 0) {

						if (ajax_link.search(/admin-ajax\.php/i) >= 0) {
							return;
						}

						jQuery.ajax({
							url: pisol_mmq.ajax_url,
							cache: false,
							type: 'POST',
							dataType: 'json',
							data: {
								action: 'get_cart_mmq'
							},
							success: function (response) {
								if (ajax_link.search(/wc-ajax=get_refreshed_fragments/i) >= 0) {
									if (parseInt(response.total_percent) == 0) {
										return;
									}
								}

								var percent = response.percent > 100 ? 1 : (parseFloat(response.percent) / 100);

								jQuery('#pi-mmq-progress-circle').circleProgress('value', percent);

								jQuery(".pisol-mmq-bar-message").html(response.message_bar);
								message.show();

							}
						});
					}
				});
			}
		};
		message.show();
		message.update_cart();
		message.close_button();
		message.close_progress();
	});

	jQuery(function () {
		var percent = pisol_mmq.percent > 100 ? 1 : (parseFloat(pisol_mmq.percent) / 100);
		jQuery('#pi-mmq-progress-circle').circleProgress({
			value: percent,
			size: 70,
			fill: {
				gradient: ["red", "orange"]
			}
		});
	});

})(jQuery);

